#!/bin/bash

#exec 2>/dev/ttyS0

#set -x

rm -rf   /tmp/firmware_upgrade
mkdir -p /tmp/firmware_upgrade

cp -r /mnt/firmware_upgrade/bin     /tmp/firmware_upgrade/bin
cp -r /mnt/firmware_upgrade/text    /tmp/firmware_upgrade/text
ln -s /mnt/firmware_upgrade/kernel  /tmp/firmware_upgrade/kernel
ln -s /mnt/firmware_upgrade/ramdisk /tmp/firmware_upgrade/ramdisk
ln -s /mnt/firmware_upgrade/flash   /tmp/firmware_upgrade/flash

PATH=$PATH:/tmp/firmware_upgrade/bin
export PATH

echo "Firmware upgrade present, launching firmware upgrade script on media card..."

rm -f /tmp/updateNeedsReboot

cd /tmp/firmware_upgrade/bin

CONSOLE_UPGRADE="/tmp/firmware_upgrade/bin/firmware_upgrade"

UPGRADE=$CONSOLE_UPGRADE

enable_matrix_kb

# Execute firmware upgrade in new virtual terminal.
/tmp/firmware_upgrade/bin/openvt -s -w $UPGRADE

# firmware_upgrade will unmount card

# Leave here if no reboot needed
[ -f /tmp/updateNeedsReboot ] ||
{
    rm -rf /tmp/firmware_upgrade
    exit 0
}

# Determine which device is mounted
if [ -f /tmp/upgradeDev ]
then
    mdev=`cat /tmp/upgradeDev`
fi

# Subroutine to determine whether device is mounted
# Return ok(0) if mounted, error(1) if not mounted or error
mounted()
{
    # Scan /var/run/stab for the mounted device
    mdev=$1
    [ -n "$mdev" ] || return 1
    mounted=`
    while read a b c d dev e
    do
	if [ "$dev" = "$mdev" ]
	then
	    echo "Yes"
	fi
    done </var/run/stab
    `
    # Return true if device is mounted
    [ -n "$mounted" ]
}

# Wait for card to be removed.
while true
do
    # Check for card inserted if we can. Otherwise sleep forever.
    if [ -n "$mdev" ]
    then
	# If it's not mounted then reboot
	mounted "$mdev" || break
    fi

    usleep 200000
done

/sbin/reboot -f
